/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.autocomplete.sources;

import club.sk1er.mods.autocomplete.AutocompleteMod;
import club.sk1er.mods.autocomplete.HypixelRank;
import club.sk1er.mods.autocomplete.JsonHolder;
import club.sk1er.mods.autocomplete.config.FriendsConfig;
import club.sk1er.mods.autocomplete.sources.AutocompleteSource;
import club.sk1er.mods.autocomplete.sources.AutocompleteSources;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public class FriendsSource
extends AutocompleteSource {
    private Set<FriendElement> data;
    private FriendsConfig config;

    FriendsSource(FriendsConfig config) {
        this.config = config;
    }

    @Override
    public Set<String> get(String command) {
        if (this.data == null || this.config == null) {
            return new HashSet<String>();
        }
        if ((AutocompleteMod.instance.getMasterConfig().getCommands().get(command) >> AutocompleteSources.FRIENDS.ordinal() & 1) != 1) {
            return new HashSet<String>();
        }
        return this.data.stream().filter(friendElement -> this.config.get(((FriendElement)friendElement).rank)).map(FriendElement::getName).collect(Collectors.toSet());
    }

    @Override
    public void refresh() {
        JsonHolder fetch = this.fetch("https://api.sk1er.club/friends/" + Minecraft.func_71410_x().func_110432_I().func_148255_b());
        HashSet<FriendElement> friendElements = new HashSet<FriendElement>();
        for (String key : fetch.getKeys()) {
            JsonHolder jsonHolder = fetch.optJsonObject(key);
            friendElements.add(new FriendElement(jsonHolder.optString("name"), HypixelRank.parse(jsonHolder.optString("rank"))));
        }
        this.data = friendElements;
    }

    class FriendElement {
        private String name;
        private HypixelRank rank;

        public FriendElement(String name, HypixelRank rank) {
            this.name = name;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FriendElement that = (FriendElement)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String getName() {
            return this.name;
        }
    }
}

